﻿

CREATE PROCEDURE [App].[NVCC_usp_GetPatient]
	@station int,   --station for pt, restricts queries local VA station
	@ssn varchar(9) -- this is the patient's SSN

AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Jerry Kohler (Original script by Dr. Charles Demosthenes)
--Object/SP Name        : NVCC_usp_GetPatient
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : app
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 01-20-2016
--
--
--Last Changed          : 02-18-2016  
--Last Changed By		: Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Request to also provide the name of the station.
--
--Purpose               : To retrieve a single patient record for the NVCC app.
--==================================================================================
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
   SET NOCOUNT ON;

     /*
      SELECT Cast(patientsid as varchar) as strPatientSID
         ,Sta3n
         ,App.udf_StationName (Sta3n) AS StationName
         ,PatientName
         ,PatientLastName
         ,PatientFirstName
         ,PatientSSN
         ,StreetAddress1
         ,StreetAddress2
         ,StreetAddress3
         ,City
         ,Zip
         ,Zip4
         ,PostalCode
         ,Province
         ,Country
         ,PhoneResidence
         ,PhoneWork
         ,PhoneCellular
         ,DateOfDeath
         ,BadAddressIndicator
         ,TemporaryAddressActiveFlag
         ,Gender
         ,Age
         ,[State]
         ,Deceased
         ,Eligibility
         ,DateOfBirth
         ,IneligibleDate
         ,EligibilityStatus
         ,EligibilityVerificationSource
   FROM  CDWWork.SPatient.SPatient
   WHERE PatientSSN like @ssn and sta3n=@station;
   */

   /* Revised on 10/26/2017 by Trinity Hall CDW Architect */

   SELECT Cast(a.patientsid as varchar) as strPatientSID
         ,a.Sta3n
         ,App.udf_StationName (a.Sta3n) AS StationName
         ,a.PatientName
         ,a.PatientLastName
         ,a.PatientFirstName
         ,a.PatientSSN
         ,b.StreetAddress1
         ,b.StreetAddress2
         ,b.StreetAddress3
         ,b.City
         ,b.Zip
         ,b.Zip4
         ,b.PostalCode
         ,b.Province
         ,b.Country
         ,c.PhoneNumber as PhoneResidence
         ,d.WorkPhoneNumber as PhoneWork
         ,e.[PhoneNumber] as PhoneCellular
         ,a.DeathDateTime as DateOfDeath
         ,b.BadAddressIndicator
         ,null as TemporaryAddressActiveFlag
         ,a.Gender
         ,a.Age
         ,b.[State]
         ,a.DeceasedFlag as Deceased
         ,a.Eligibility
         ,a.BirthDateTime as DateOfBirth
         ,a.IneligibleDateTime as IneligibleDate
         ,a.EligibilityStatus
         ,a.EligibilityVerificationSource
   FROM		 CDWWork.SPatient.SPatient a
   Left join CDWWork.Spatient.SPatientAddress b on a.PatientSID = b.PatientSID and b.OrdinalNumber = 13
   left join CDWWork.Spatient.SpatientPhone c on a.PatientSID = c.PatientSID and c.OrdinalNumber = 13
   left join CDWWork.Spatient.SpatientPhone d on a.PatientSID = d.PatientSID and d.OrdinalNumber = 9
   left join CDWWork.Spatient.SpatientPhone e on a.PatientSID = e.PatientSID and e.OrdinalNumber = 14


   WHERE PatientSSN like @ssn and a.sta3n=@station;
END;